;----------------------------------------------------------------------------
; Atomiswave
; Demul .56  
; by BBB
; 1.0
;
; Notes:
;
;----------------------------------------------------------------------------

;Settings
loadingScreen=1
fullscreenWidth = 800
fullscreenHeight = 600


if(loadingScreen){
  Gui +AlwaysOnTop -Caption +ToolWindow 
  Gui, Color, Black
  logoXPos := A_ScreenWidth/2 - 900 /2
  Gui, Add, Picture,x%logoXPos% y120, %A_ScriptDir%\Modules\Atomiswave\Logo.png
  loadXPos := A_ScreenWidth/2 - 300 /2
  loadYPos := A_ScreenHeight - 100
  Gui, Add, Picture,x%loadXPos% y%loadYPos%, %A_ScriptDir%\Modules\Atomiswave\Loading.png
  Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%
}

demofist := Object("name", "Demolition Fist", "controls", "standard")
dolphin := Object("name", "Dolphin Blue", "controls", "standard")
fotns := Object("name", "Fist of the North Star", "controls", "standard")
ggisuka := Object("name", "Guilty Gear Isuka", "controls", "ggxstyle")
kof11 := Object("name", "King of Fighters 11", "controls", "standard")
kofnw := Object("name", "King of Fighters NeoWave", "controls", "sfstyle")
kofnwj := Object("name", "King of Fighters NeoWave (JAP)", "controls", "sfstyle")
kov7sprt := Object("name", "Knights of Valor - The Seven Spirits", "controls", "standard")
rangrmsn := Object("name", "Ranger Mission", "controls", "lightgun")
rumblef := Object("name", "The Rumble Fish", "controls", "sfstyle")
salmankt := Object("name", "Salary Man Kintaro", "controls", "standard")
sprtshot := Object("name", "Sports Shooting USA", "controls", "lightgun")
vfurlong := Object("name", "Net Select Keiba Victory Furlong", "controls", "standard")
xtrmhunt := Object("name", "Extreme Hunting", "controls", "lightgun")
xtrmhnt2 := Object("name", "Extreme Hunting 2", "controls", "lightgun")

currentName := %RomName%.name
currentControls := %RomName%.controls

settingsFile = %emupath%Demul.ini
padFile = %emupath%padDemul.ini

;All Atomiswave games use standard controls code from what I seen
if(currentControls = "lightgun"){
  IniWrite, 131072, %settingsFile%, PORTB, device
  IniWrite, standard, %padFile%, CONTROL_TYPE, CONTROL_TYPE
}else{
  IniWrite, 16777216, %settingsFile%, PORTB, device
  IniWrite, currentControls, %padFile%, CONTROL_TYPE, CONTROL_TYPE
}

if(currentControls = "standard" || currentControls = "lightgun"){
  WriteStandardControls()
}
else if(currentControls = "ggxstyle"){
  WriteGGXControls()
}
else if(currentControls = "sfstyle"){
  WriteSFStyleControls() 
}
else if(currentControls = "lightgun"){
  WriteStandardControls()
}

WriteStandardControls(){
  IniWrite, 200, %padFile%, ATOMISWAVE0_0, UP
  IniWrite, 208, %padFile%, ATOMISWAVE0_0, DOWN
  IniWrite, 203, %padFile%, ATOMISWAVE0_0, LEFT
  IniWrite, 205, %padFile%, ATOMISWAVE0_0, RIGHT
  IniWrite, 46,  %padFile%, ATOMISWAVE0_0, SHOT1
  IniWrite, 18,  %padFile%, ATOMISWAVE0_0, SHOT2
  IniWrite, 44,  %padFile%, ATOMISWAVE0_0, SHOT3
  IniWrite, 45,  %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 21,  %padFile%, ATOMISWAVE0_0, SHOT5
  IniWrite, 38,  %padFile%, ATOMISWAVE0_0, START
  IniWrite, 39,  %padFile%, ATOMISWAVE0_0, COIN

  IniWrite, 72, %padFile%, ATOMISWAVE0_1, UP
  IniWrite, 76, %padFile%, ATOMISWAVE0_1, DOWN
  IniWrite, 75, %padFile%, ATOMISWAVE0_1, LEFT
  IniWrite, 77, %padFile%, ATOMISWAVE0_1, RIGHT
  IniWrite, 50, %padFile%, ATOMISWAVE0_1, SHOT1
  IniWrite, 47, %padFile%, ATOMISWAVE0_1, SHOT2
  IniWrite, 48, %padFile%, ATOMISWAVE0_1, SHOT3
  IniWrite, 45, %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 25, %padFile%, ATOMISWAVE0_1, SHOT5
  IniWrite, 19, %padFile%, ATOMISWAVE0_1, START
  IniWrite, 51, %padFile%, ATOMISWAVE0_1, COIN
}

WriteGGXControls(){
  IniWrite, 18,  %padFile%, ATOMISWAVE0_0, SHOT2
  IniWrite, 44,  %padFile%, ATOMISWAVE0_0, SHOT3
  IniWrite, 20,  %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 21,  %padFile%, ATOMISWAVE0_0, SHOT5
  
  IniWrite, 47, %padFile%, ATOMISWAVE0_1, SHOT2
  IniWrite, 48, %padFile%, ATOMISWAVE0_1, SHOT3
  IniWrite, 24, %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 25, %padFile%, ATOMISWAVE0_1, SHOT5
}

WriteSFStyleControls(){
  IniWrite, 45,  %padFile%, ATOMISWAVE0_0, SHOT2
  IniWrite, 21,  %padFile%, ATOMISWAVE0_0, SHOT3
  IniWrite, 18,  %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 44,  %padFile%, ATOMISWAVE0_0, SHOT5
  
  IniWrite, 49, %padFile%, ATOMISWAVE0_1, SHOT2
  IniWrite, 25, %padFile%, ATOMISWAVE0_1, SHOT3
  IniWrite, 47,  %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 48, %padFile%, ATOMISWAVE0_1, SHOT5 
}

IniWrite, %fullscreenWidth%, %emupath%gpuOglv3.ini, resolution, fWidth
IniWrite, %fullscreenHeight%, %emupath%gpuOglv3.ini, resolution, fHeight
Run, "%Emupath%%Executable%" -run=atomiswave -rom=%RomName%
SetTimer, CheckWin, 2

sizeOrg=
CheckWin:
IfWinNotExist, ahk_class window
{
   return
}else{
   WinGetPos,,,W,,ahk_class window
   if(W != sizeOrg && sizeOrg != ""){
      Goto StartGame
   }else{
      sizeOrg = %W%
   }
}
return

StartGame:
  SetTimer, CheckWin, Off
  WinActivate ahk_class window
  Send !{ENTER}
  Gui Destroy
  Process, WaitClose, %executable%
return
           
CloseProcess:
  Process, Close, %executable%
  ExitApp  
return